<?php

namespace App\Http\Controllers;

use App\Models\Rupture;
use App\Models\StockProduit;
use App\Models\Magasin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class RuptureController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('manage-action',['stock','lister']);
        $ruptures = DB::table('ruptures')
            ->join('produits','produits.produit_id','=','ruptures.produit_id')
            ->join('magasins','magasins.magasin_id','=','ruptures.magasin_id')
            ->orderBy('date_rupture')
            ->get();

        $produits = StockProduit::where('centre_id','=',Auth::user()->centre_id)
            ->pluck('libelle','produit_id');

        $magasins = Magasin::where('statut','=','true')
            ->where('centre_id','=',Auth::user()->centre_id)
            ->pluck('libelle','magasin_id');
        $currentDate = Carbon::now()->toDateString();    
        if(request()->ajax())
        {
            return datatables()->of($ruptures)
                ->addColumn('action', function($rupture){
                    $button = '<button type="button" name="editer" id="'.$rupture->rupture_id.'" class="editer btn btn-success btn-sm"><i class="fa fa-edit"></i></button>';
                    $button .= '&nbsp;&nbsp;';
                    $button .= '<button type="button" name="delete" id="'.$rupture->rupture_id.'" class="delete btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>';
                    return $button;
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        return view('rupture.index',compact('magasins','produits','currentDate'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $rules = array(
            'date_rupture'    =>  'required|date',
            'date_debut'     =>  'required|date',
            'date_fin'     =>  'required|date:',
            'magasin_id'     =>  'required|numeric|min:1',
            'produit_id'     =>  'required|numeric|min:1'
        );

        $error = Validator::make($request->all(), $rules);
        if($error->fails())
        {
            return response()->json(['errors' => $error->errors()->all()]);
        }
        $fin = Carbon::parse($request->date_fin);
        $debut = Carbon::parse($request->date_debut);
        $form_data = array(
            'date_rupture' =>  $request->date_rupture,
            'date_debut'  =>  $request->date_debut,
            'date_fin'  =>  $request->date_fin,
            'nombre_jour'  =>  $fin->diffInDays($debut),
            'magasin_id'  =>  $request->magasin_id,
            'produit_id'  =>  $request->produit_id,
            'user_id'  =>  Auth::user()->id,
            'centre_id'  =>  Auth::user()->centre_id,
            'dps_id'  =>  Auth::user()->dps_id
        );

        $produit= DB::table('produits')
            ->Where('statut','=','yes')
            ->Where('nom_commercial','=',$request->nom_commercial)
            ->get();
        if ($request->date_debut==$request->date_fin){
            return response()->json(['error' => 'Les dates debut et fin doivent etre differentes.']);
        }else{
            if ($request->rupture_id==null){
                DB::beginTransaction();
                try {
                    Rupture::create($form_data);
                    //DB::connection('vps')->table('produits')->insert($form_data);
                    DB::commit();
                    return response()->json(['success' => 'Rupture enregistree avec success.']);
                } catch (\Throwable $th) {
                    DB::rollBack();
                    return response()->json(['error' => 'Erreur survenu lors de l\'enregistrement.']);
                }
            }else{
                DB::beginTransaction();
                try {
                    Rupture::find($request->rupture_id)->update($form_data);
                    //DB::connection('vps')->table('produits')->insert($form_data);
                    DB::commit();
                    return response()->json(['success' => 'Rupture modifiee avec success.']);
                } catch (\Throwable $th) {
                    DB::rollBack();
                    return response()->json(['error' => 'Erreur survenu lors de l enregistrement.']);
                }
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Rupture  $rupture
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if (\request()->ajax()){
            return response()->json(Rupture::find($id));
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Rupture  $rupture
     * @return \Illuminate\Http\Response
     */
    public function edit(Rupture $rupture)
    {
        //
    }

    public function delete($id)
    {
        if (\request()->ajax()){
            try {
                DB::beginTransaction();
                Rupture::find($id)->delete();
                //DB::connection('vps')->table('produits')->where('produit_id',$id)->update(['statut'=>'false']);
                DB::commit();
                return back()->with('success', 'Le Produit a ete supprime');
            } catch (\Throwable $th) {
                DB::rollBack();
                Alert::error('Erreur !', 'Une erreur s\'est produite.');
            }
        }

    }
}
